<?php
declare(strict_types=1);
require __DIR__ . '/../vendor/autoload.php';

function loadEnv(): void {
    $envFile = __DIR__ . '/../.env';
    if (!is_file($envFile)) return;
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '' || $line[0] === '#') continue;
        $pos = strpos($line, '=');
        if ($pos === false) continue;
        $k = trim(substr($line, 0, $pos));
        $v = trim(substr($line, $pos + 1));
        $_ENV[$k] = $v;
    }
}
loadEnv();
function env(string $key, ?string $default=null): string { return $_ENV[$key] ?? ($default ?? ''); }

if (session_status() === PHP_SESSION_NONE) {
    session_name(env('SESSION_NAME', 'cidf_sess'));
    session_start();
}
if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }

function csrf_input(): void {
    $t = htmlspecialchars($_SESSION['csrf'] ?? '', ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8');
    echo '<input type="hidden" name="csrf" value="'.$t.'">';
}
function csrf_check(): void {
    if (($_POST['csrf'] ?? '') !== ($_SESSION['csrf'] ?? '')) { http_response_code(403); exit('CSRF'); }
}

function brand_name(): string { return env('BRAND_NAME', 'Docs véhicule'); }
function brand_color(): string { return env('BRAND_COLOR', '#111111'); }
function brand_logo(): string { return env('LOGO_URL', ''); }
