<?php
declare(strict_types=1);
namespace App;
class Storage {
    public static function storeUpload(array $file): array {
        if (($file['error'] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) throw new \RuntimeException('Erreur upload');
        $sizeMax = (int)($_ENV['UPLOAD_MAX_BYTES'] ?? 10485760);
        if ($file['size'] > $sizeMax) throw new \RuntimeException('Fichier trop gros');
        $allowed = array_map('trim', explode(',', $_ENV['ALLOWED_MIME'] ?? 'application/pdf,image/jpeg,image/png'));
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mime = finfo_file($finfo, $file['tmp_name']);
        if (!in_array($mime, $allowed,true)) throw new \RuntimeException('Type non autorisé');
        $base = bin2hex(random_bytes(8));
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $stored = $base . '.' . $ext;
        $dest = __DIR__ . '/../storage/files/' . $stored;
        if (!move_uploaded_file($file['tmp_name'], $dest)) throw new \RuntimeException('Echec move');
        chmod($dest, 0640);
        return ['filename'=>$file['name'],'stored_name'=>$stored,'mime'=>$mime,'size'=>$file['size']];
    }
}
