<?php
declare(strict_types=1);
use App\DB;
require __DIR__ . '/../src/bootstrap.php';
require __DIR__ . '/../src/DB.php';
$id = (string)($_GET['id'] ?? '');
$token = $_GET['t'] ?? null;
$doc = DB::doc($id);
if (!$doc) { http_response_code(404); exit('Not found'); }
$hasAccess = ($token && hash_equals((string)$doc['token'], (string)$token)) || isset($_SESSION['uid']);
if (!$hasAccess) { $redirect = '/p/' . rawurlencode($id); header('Location: /?redirect=' . rawurlencode($redirect)); exit; }
$baseUrl = rtrim(env('APP_URL', 'http://localhost:8080'), '/');
$publicUrl = $baseUrl . '/d/' . rawurlencode($doc['id']) . (!empty($doc['token']) ? ('?t=' . rawurlencode((string)$doc['token'])) : '');
$wmEnabled = (int)(env('WATERMARK_ENABLED','0')) === 1;
$wmText = env('WATERMARK_TEXT','COPIE');
$logo = brand_logo();
$brand = brand_name();
$color = brand_color();
?>
<!doctype html>
<html lang="fr">
<head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title><?=$brand?> — <?=htmlspecialchars($doc['filename'])?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
:root { --brand: <?=$color?>; }
.header{display:flex;justify-content:space-between;align-items:center;border-bottom:1px solid #e5e7eb;padding-bottom:.5rem;margin-bottom:1rem}
.badge-soft{background:#f1f5f9;border:1px solid #e2e8f0;color:#0f172a}
.meta dt{color:#6b7280;width:160px}
.meta dd{margin:0}
.viewer{position:relative;border:1px solid #e5e7eb;border-radius:.5rem;overflow:hidden;background:#fff;height:75vh}
.watermark{position:absolute;inset:0;display:<?= $wmEnabled ? 'block':'none' ?>;pointer-events:none;
  background-image: repeating-linear-gradient(45deg, rgba(0,0,0,.08) 0, rgba(0,0,0,.08) 1px, transparent 1px, transparent 120px);
}
.watermark::before{content:"<?=$wmText?>"; position:absolute; top:50%; left:50%; transform:translate(-50%,-50%) rotate(-25deg);
  font-size:56px; color:rgba(0,0,0,.12); letter-spacing:.2em; white-space:nowrap;
}
.brand{display:flex;align-items:center;gap:.75rem}
.brand .dot{width:10px;height:10px;border-radius:50%;background:var(--brand)}
</style>
</head>
<body class="bg-light">
<div class="container py-4">
  <div class="header">
    <div class="brand">
      <?php if($logo): ?><img src="<?=$logo?>" alt="" style="height:32px"><?php else:?><span class="dot"></span><?php endif; ?>
      <strong><?=$brand?></strong>
    </div>
    <img src="<?=$baseUrl.'/generate_qr.php?id='.htmlspecialchars($doc['id'])?>" alt="QR" width="96" height="96" class="border rounded">
  </div>

  <div class="row g-3 mb-3">
    <div class="col-12 col-lg-8">
      <div class="viewer">
        <iframe src="<?=$publicUrl?>" title="document" style="width:100%;height:100%;border:0;"></iframe>
        <div class="watermark"></div>
      </div>
    </div>
    <div class="col-12 col-lg-4">
      <div class="card"><div class="card-body">
        <h2 class="h6 mb-3">Détails</h2>
        <dl class="row meta">
          <dt class="col-5">Fichier</dt><dd class="col-7 text-break"><?=htmlspecialchars($doc['filename'])?></dd>
          <dt class="col-5">Type</dt><dd class="col-7"><span class="badge badge-soft"><?=htmlspecialchars($doc['type'] ?? '—')?></span></dd>
          <dt class="col-5">Taille</dt><dd class="col-7"><?=number_format((int)$doc['size']/1024,1,'.',' ')?> Ko</dd>
          <dt class="col-5">Créé</dt><dd class="col-7"><span class="badge badge-soft"><?=htmlspecialchars($doc['created_at'])?></span></dd>
          <dt class="col-5">Expire</dt><dd class="col-7"><?=htmlspecialchars($doc['expires_at'] ?? '—')?></dd>
          <dt class="col-5">Immat.</dt><dd class="col-7"><?=htmlspecialchars($doc['vehicle_ref'] ?? '—')?></dd>
          <dt class="col-5">Accès</dt><dd class="col-7 text-break"><code><?=$publicUrl?></code></dd>
        </dl>
        <div class="d-grid gap-2">
          <a class="btn btn-dark" href="<?=$publicUrl?>" target="_blank">Ouvrir dans un nouvel onglet</a>
          <button class="btn btn-outline-secondary" type="button" onclick="navigator.clipboard.writeText('<?=$publicUrl?>')">Copier le lien</button>
          <?php if(isset($_SESSION['uid'])): ?>
            <a class="btn btn-outline-secondary" href="/" >Retour admin</a>
          <?php endif; ?>
        </div>
      </div></div>
    </div>
  </div>
</div>
</body>
</html>
