<?php
declare(strict_types=1);
use App\DB;
require __DIR__ . '/../src/bootstrap.php';
require __DIR__ . '/../src/DB.php';
$id = (string)($_GET['id'] ?? '');
$token = isset($_GET['t']) ? (string)$_GET['t'] : null;
$doc = DB::doc($id);
if (!$doc) { http_response_code(404); exit('Not found'); }
if (!$token || !hash_equals((string)$doc['token'], (string)$token)) {
    if (!isset($_SESSION['uid'])) {
        $redirect = '/d/' . rawurlencode($id);
        header('Location: /?redirect=' . rawurlencode($redirect)); exit;
    }
}
$path = __DIR__ . '/../storage/files/' . $doc['stored_name'];
if (!is_file($path)) { http_response_code(410); exit('Gone'); }
header('Content-Type: ' . $doc['mime']);
header('Content-Disposition: inline; filename="' . basename($doc['filename']) . '"');
header('Content-Length: ' . filesize($path));
readfile($path);
