<?php
declare(strict_types=1);
use App\DB;
require __DIR__ . '/../src/bootstrap.php';
require __DIR__ . '/../src/DB.php';

$ref = (string)($_GET['ref'] ?? '');
$vt = (string)($_GET['t'] ?? '');
$veh = DB::vehicle($ref);
if (!$veh) { http_response_code(404); exit('Vehicule inconnu'); }

$allowed = (isset($_SESSION['uid'])) || ($vt && hash_equals((string)$veh['token'], (string)$vt));
if (!$allowed) {
    $redirect = '/v/' . rawurlencode($ref);
    header('Location: /?redirect=' . rawurlencode($redirect)); exit;
}

$docs = DB::vehicleDocs($ref);
$baseUrl = rtrim(env('APP_URL', 'http://localhost:8080'), '/');
$logo = brand_logo();
$brand = brand_name();
$color = brand_color();

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); }
function docurl($d,$base){ $u=$base.'/p/'.$d['id']; if(!empty($d['token'])) $u.='?t='.$d['token']; return $u; }
?>
<!doctype html>
<html lang="fr">
<head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title><?=$brand?> — Dossier véhicule <?=h($ref)?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
:root { --brand: <?=$color?>; }
.header{display:flex;justify-content:space-between;align-items:center;border-bottom:1px solid #e5e7eb;padding-bottom:.5rem;margin-bottom:1rem}
.card-doc{border:1px solid #e5e7eb;border-radius:.5rem}
.brand{display:flex;align-items:center;gap:.75rem}
.brand .dot{width:10px;height:10px;border-radius:50%;background:var(--brand)}
</style>
</head>
<body class="bg-light">
<div class="container py-4">
  <div class="header">
    <div class="brand">
      <?php if($logo): ?><img src="<?=$logo?>" alt="" style="height:32px"><?php else:?><span class="dot"></span><?php endif; ?>
      <strong><?=$brand?></strong>
    </div>
    <div class="text-end">
      <div class="fw-semibold">Dossier véhicule</div>
      <div class="text-muted small"><?=h($ref)?></div>
    </div>
  </div>

  <?php if(empty($docs)): ?>
    <div class="alert alert-warning">Aucun document pour ce véhicule.</div>
  <?php endif; ?>

  <div class="row g-3">
  <?php
  $order = ['assurance'=>'Assurance','carte_grise'=>'Carte grise','critair'=>'Certificat Qualité de l\'air','autre'=>'Autre'];
  usort($docs, function($a,$b) use ($order){ return (array_key_exists($a['type'],$order)?array_search($a['type'],array_keys($order)):99) <=> (array_key_exists($b['type'],$order)?array_search($b['type'],array_keys($order)):99); });
  foreach ($docs as $d):
    $u = docurl($d,$baseUrl);
  ?>
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card card-doc h-100">
        <div class="card-body d-flex flex-column">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="fw-semibold"><?=h($order[$d['type']] ?? ucfirst((string)$d['type'] ?: 'Document'))?></div>
            <img class="border rounded" src="<?=$baseUrl.'/generate_qr.php?id='.h($d['id'])?>" width="72" height="72" alt="QR">
          </div>
          <div class="small text-muted mb-2"><?=h($d['filename'])?></div>
          <div class="mb-2"><span class="badge text-bg-light"><?=h($d['created_at'])?></span>
          <?php if(!empty($d['expires_at'])): ?> <span class="badge text-bg-warning">Expire: <?=h($d['expires_at'])?></span><?php endif; ?></div>
          <div class="mt-auto d-grid gap-2">
            <a class="btn btn-dark" target="_blank" href="<?=h($u)?>">Ouvrir</a>
            <button class="btn btn-outline-secondary" type="button" onclick="navigator.clipboard.writeText('<?=h($u)?>')">Copier le lien</button>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
  </div>
</div>
</body>
</html>
