<?php
declare(strict_types=1);
use App\DB; use App\Storage;
require __DIR__ . '/../src/bootstrap.php';
require __DIR__ . '/../src/DB.php';
require __DIR__ . '/../src/Storage.php';
$baseUrl = rtrim(env('APP_URL', 'http://localhost:8080'), '/');
$brand = brand_name(); $logo = brand_logo(); $color = brand_color();

// auth
$err='';
if (isset($_POST['login_email'], $_POST['login_password'])) { csrf_check(); $user = DB::userByEmail(trim($_POST['login_email'])); if ($user && password_verify($_POST['login_password'], $user['password_hash'])) { $_SESSION['uid']=$user['id']; header('Location:/'); exit; } $err='Identifiants invalides'; }
if (isset($_GET['logout'])) { session_destroy(); header('Location:/'); exit; }
$logged = isset($_SESSION['uid']);

// actions
if ($logged && ($_POST['action'] ?? null)==='regen') { csrf_check(); DB::updateToken((string)$_POST['id'], bin2hex(random_bytes(16))); header('Location:/?ok=regen'); exit; }
if ($logged && ($_POST['action'] ?? null)==='delete') { csrf_check(); $id=(string)$_POST['id']; $doc=DB::doc($id); if ($doc) { @unlink(__DIR__.'/../storage/files/'.$doc['stored_name']); DB::deleteDoc($id); } header('Location:/?ok=deleted'); exit; }
if ($logged && ($_POST['action'] ?? null)==='purge_all') { csrf_check(); foreach (DB::docs() as $d) { @unlink(__DIR__.'/../storage/files/'.$d['stored_name']); } DB::purgeAll(); header('Location:/?ok=purged'); exit; }

// upload
$notice='';
if ($logged && ($_POST['action'] ?? '')==='upload' && isset($_FILES['doc'])) {
    csrf_check();
    try{
        $stored = Storage::storeUpload($_FILES['doc']);
        $docId  = bin2hex(random_bytes(8));
        $token  = bin2hex(random_bytes(16));
        $vehRef = trim($_POST['vehicle_ref'] ?? '');
        if ($vehRef !== '') { DB::ensureVehicle($vehRef); }
        $type   = in_array($_POST['type'] ?? '', ['assurance','carte_grise','critair','autre'], true) ? $_POST['type'] : 'autre';
        $expires= trim($_POST['expires_at'] ?? '');
        DB::insertDoc([
            'id'=>$docId,'vehicle_ref'=>$vehRef ?: null,
            'filename'=>$stored['filename'],'stored_name'=>$stored['stored_name'],'mime'=>$stored['mime'],'size'=>$stored['size'],
            'token'=>$token,'type'=>$type,'expires_at'=>$expires ?: null
        ]);
        $notice = $baseUrl.'/p/'.$docId.'?t='.$token;
    }catch(\Throwable $e){ $err=$e->getMessage(); }
}
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES|ENT_SUBSTITUTE,'UTF-8'); }
$docs = $logged ? DB::docs() : [];
?>
<!doctype html><html lang="fr"><head><meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title><?=$brand?> — Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
:root { --brand: <?=$color?>; }
.navbar-brand{display:flex;align-items:center;gap:.5rem}
.brand-dot{width:10px;height:10px;border-radius:50%;background:var(--brand)}
</style>
</head><body>
<nav class="navbar navbar-expand-lg bg-body-tertiary border-bottom"><div class="container-fluid">
  <a class="navbar-brand fw-semibold" href="/"><?php if($logo): ?><img src="<?=$logo?>" alt="" style="height:24px"><?php else: ?><span class="brand-dot"></span><?php endif; ?> <?=$brand?></a>
  <div class="d-flex">
    <?php if($logged): ?>
      <a class="btn btn-outline-secondary btn-sm me-2" href="/admin_export.php"><i class="bi bi-download"></i> Export CSV</a>
      <a class="btn btn-outline-secondary btn-sm" href="/?logout=1">Déconnexion</a>
    <?php endif; ?>
  </div>
</div></nav>
<main class="container py-4">
<?php if(!$logged): ?>
  <div class="row justify-content-center"><div class="col-12 col-md-6"><div class="card shadow-sm"><div class="card-body">
    <h1 class="h4 mb-3">Connexion</h1>
    <?php if($err): ?><div class="alert alert-danger py-2"><?=h($err)?></div><?php endif; ?>
    <form method="post" class="vstack gap-2"><?php csrf_input(); ?>
      <div><label class="form-label">Email</label><input class="form-control" type="email" name="login_email" required></div>
      <div><label class="form-label">Mot de passe</label><input class="form-control" type="password" name="login_password" required></div>
      <div class="d-grid"><button class="btn btn-dark" type="submit">Se connecter</button></div>
    </form>
  </div></div><p class="text-muted small mt-3">Vérifie <code>.env</code> (email/mot de passe admin).</p></div></div>
<?php else: ?>
  <div class="row g-3 mb-3">
    <div class="col-12 col-lg-6"><div class="card shadow-sm h-100"><div class="card-body">
      <h2 class="h5">Uploader un document</h2>
      <?php if($notice): ?><div class="alert alert-success py-2"><div>Fiche publique :</div><div class="small text-break"><code id="newLink"><?=h($notice)?></code></div><button class="btn btn-sm btn-outline-secondary mt-2" type="button" onclick="navigator.clipboard.writeText(document.getElementById('newLink').textContent)">Copier</button></div><?php endif; ?>
      <?php if($err): ?><div class="alert alert-danger py-2"><?=h($err)?></div><?php endif; ?>
      <form method="post" enctype="multipart/form-data" class="row g-2"><?php csrf_input(); ?><input type="hidden" name="action" value="upload" />
        <div class="col-12 col-md-6"><label class="form-label">Réf véhicule</label><input class="form-control" type="text" name="vehicle_ref" placeholder="AA-123-BB"></div>
        <div class="col-12 col-md-6"><label class="form-label">Type</label>
          <select class="form-select" name="type">
            <option value="assurance">Assurance</option>
            <option value="carte_grise">Carte grise</option>
            <option value="critair">Certificat Qualité de l'air</option>
            <option value="autre" selected>Autre</option>
          </select>
        </div>
        <div class="col-12 col-md-6"><label class="form-label">Expiration (optionnel)</label><input class="form-control" type="date" name="expires_at"></div>
        <div class="col-12"><label class="form-label">Fichier (PDF/JPG/PNG ≤ 10 Mo)</label><input class="form-control" type="file" name="doc" accept="application/pdf,image/jpeg,image/png" required></div>
        <div class="col-12 d-grid mt-1"><button class="btn btn-dark" type="submit">Uploader</button></div>
      </form>
    </div></div></div>
    <div class="col-12 col-lg-6"><div class="card shadow-sm h-100"><div class="card-body">
      <h2 class="h5">Actions</h2>
      <form method="post" onsubmit="return confirm('Confirmer la suppression de TOUS les documents ?');" class="vstack gap-2">
        <?php csrf_input(); ?><input type="hidden" name="action" value="purge_all" />
        <button class="btn btn-outline-danger" type="submit">Purger tous les documents</button>
      </form>
      <hr>
      <form class="vstack gap-2" method="get" action="/vehicle.php">
        <label class="form-label">Voir la fiche véhicule (public)</label>
        <div class="input-group">
          <input type="text" class="form-control" name="ref" placeholder="AA-123-BB" required>
          <button class="btn btn-outline-secondary" type="submit">Ouvrir</button>
        </div>
        <div class="small text-muted">Astuce: la fiche publique nécessite le token véhicule <code>?t=...</code>. Tu peux copier le QR ci-dessous depuis la liste.</div>
      </form>
    </div></div></div>
  </div>
  <div class="card shadow-sm"><div class="card-body">
    <div class="d-flex justify-content-between align-items-center mb-2"><h2 class="h5 m-0">Documents</h2><div class="text-muted small"><?=count($docs)?> élément(s)</div></div>
    <div class="table-responsive"><table class="table align-middle">
      <thead class="table-light"><tr><th>Immat.</th><th>Type</th><th>Fichier</th><th>Taille</th><th>Créé</th><th>Expire</th><th>Fiche doc</th><th>QR doc</th><th>QR véhicule</th><th>Actions</th></tr></thead>
      <tbody>
      <?php foreach($docs as $d):
        $u=$baseUrl.'/p/'.$d['id'].($d['token']?('?t='.$d['token']):'');
        $vehTok = $d['vehicle_ref'] ? (App\DB::vehicleToken($d['vehicle_ref']) ?? App\DB::ensureVehicle($d['vehicle_ref'])) : null;
        $vehUrl = $d['vehicle_ref'] ? ($baseUrl.'/v/'.$d['vehicle_ref'].'?t='.$vehTok) : null;
      ?>
        <tr>
          <td class="text-nowrap"><?=h($d['vehicle_ref'] ?? '')?></td>
          <td><?=h($d['type'] ?? '—')?></td>
          <td class="text-truncate" style="max-width:260px" title="<?=h($d['filename'])?>"><?=h($d['filename'])?></td>
          <td><?=number_format((int)$d['size']/1024,1,'.',' ')?> Ko</td>
          <td><span class="badge text-bg-light"><?=h($d['created_at'])?></span></td>
          <td><?=h($d['expires_at'] ?? '—')?></td>
          <td><a class="btn btn-sm btn-outline-secondary" target="_blank" href="<?=h($u)?>">Ouvrir</a></td>
          <td><?php if($d['id']): ?><img class="border rounded" src="<?=h($baseUrl.'/generate_qr.php?id='.$d['id'])?>" width="64" height="64" alt="QR doc"><?php endif; ?></td>
          <td><?php if($vehUrl): ?><img class="border rounded" src="<?=h($baseUrl.'/generate_qr.php?mode=vehicle&ref='.$d['vehicle_ref'])?>" width="64" height="64" alt="QR véhicule"><?php endif; ?></td>
          <td class="text-nowrap">
            <form method="post" class="d-inline" onsubmit="return confirm('Regénérer le token ?');"><?php csrf_input(); ?><input type="hidden" name="action" value="regen" /><input type="hidden" name="id" value="<?=h($d['id'])?>" /><button class="btn btn-sm btn-outline-primary" type="submit">Token</button></form>
            <form method="post" class="d-inline" onsubmit="return confirm('Supprimer ce document ?');"><?php csrf_input(); ?><input type="hidden" name="action" value="delete" /><input type="hidden" name="id" value="<?=h($d['id'])?>" /><button class="btn btn-sm btn-outline-danger" type="submit">Suppr</button></form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody></table></div>
  </div></div>
<?php endif; ?>
</main></body></html>
