<?php
declare(strict_types=1);
@ini_set('display_errors','0');
require __DIR__ . '/../src/bootstrap.php';
require __DIR__ . '/../src/DB.php';
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\SvgWriter;
use App\DB;
if (ob_get_length()) { ob_end_clean(); }
$mode = $_GET['mode'] ?? 'doc'; // 'doc' or 'vehicle'
$baseUrl = rtrim(env('APP_URL', 'http://localhost:8080'), '/');
if ($mode === 'vehicle') {
    $ref = (string)($_GET['ref'] ?? '');
    if ($ref==='') { http_response_code(400); exit; }
    $veh = DB::vehicle($ref);
    if (!$veh) { http_response_code(404); exit; }
    $url = $baseUrl . '/v/' . rawurlencode($ref) . '?t=' . rawurlencode((string)$veh['token']);
} else {
    $id = (string)($_GET['id'] ?? '');
    if ($id==='') { http_response_code(400); exit; }
    $doc = DB::doc($id);
    if (!$doc) { http_response_code(404); exit; }
    $url = $baseUrl . '/p/' . rawurlencode($id);
    if (!empty($doc['token'])) $url .= '?t=' . rawurlencode((string)$doc['token']);
}
$qr = QrCode::create($url)->setSize(300)->setMargin(6);
$writer = new SvgWriter();
$result = $writer->write($qr);
header('Content-Type: image/svg+xml; charset=utf-8');
header('X-Content-Type-Options: nosniff');
echo $result->getString();
exit;
