<?php
declare(strict_types=1);
use App\DB;
require __DIR__ . '/../src/bootstrap.php';
require __DIR__ . '/../src/DB.php';

$key = $_GET['key'] ?? '';
if (!hash_equals(env('REMINDER_KEY',''), (string)$key)) { http_response_code(403); exit('Forbidden'); }

$daysConf = array_filter(array_map('trim', explode(',', env('REMINDER_DAYS','7,30'))));
$days = array_map('intval', $daysConf);
$now = new DateTimeImmutable('now', new DateTimeZone('UTC'));

$docs = DB::docs(); // filter here
$expiring = [];
foreach ($docs as $d) {
  if (empty($d['expires_at'])) continue;
  try { $exp = new DateTimeImmutable($d['expires_at'], new DateTimeZone('UTC')); } catch (Throwable $e) { continue; }
  $diffDays = (int) round(($exp->getTimestamp() - $now->getTimestamp()) / 86400);
  if (in_array($diffDays, $days, true)) {
    $expiring[] = ['in'=>$diffDays, 'veh'=>$d['vehicle_ref'], 'type'=>$d['type'], 'filename'=>$d['filename'], 'date'=>$d['expires_at']];
  }
}

header('Content-Type: text/plain; charset=utf-8');
if (empty($expiring)) { echo "No reminders\n"; exit; }

$lines = ["Documents à échéance :"];
foreach ($expiring as $e) {
  $lines[] = sprintf("J-%d | %s | %s | %s | %s", $e['in'], $e['veh'] ?: '-', $e['type'] ?: '-', $e['filename'], $e['date']);
}
$body = implode("\n", $lines);
echo $body, "\n";

// Envoi mail simple (si possible sur l'hébergement)
$to = env('ADMIN_EMAIL','');
if ($to) {
  @mail($to, '[CIDF Docs] Rappels d\'échéance', $body, "Content-Type: text/plain; charset=utf-8");
}
