CREATE TABLE IF NOT EXISTS users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    email TEXT UNIQUE,
    password_hash TEXT NOT NULL,
    created_at TEXT
);
CREATE TABLE IF NOT EXISTS documents (
    id TEXT PRIMARY KEY,
    vehicle_ref TEXT,
    filename TEXT,
    stored_name TEXT,
    mime TEXT,
    size INTEGER,
    created_at TEXT,
    token TEXT,
    type TEXT,
    expires_at TEXT
);
CREATE TABLE IF NOT EXISTS vehicles (
    vehicle_ref TEXT PRIMARY KEY,
    token TEXT,
    created_at TEXT
);
CREATE INDEX IF NOT EXISTS idx_documents_vehicle ON documents(vehicle_ref);
